/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Eco Web controls                 }
{ Copyright (c) 2003 - 2005 Borland Software Corporation}
{                                                       }
{*******************************************************/

using System;
using System.IO;
using System.Collections;
using System.Collections.Specialized;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Drawing.Design;
using System.Runtime.Serialization;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;
using System.Text;
using System.Runtime.Serialization.Formatters.Soap;
using System.Data;
using System.Reflection;
using Borland.Data.Web;
using Borland.Eco.Services;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Handles;

namespace Borland.Data.Web.Eco
{

		public interface IEcoPageStateManager
		{
			Object GetTableOrView(Page page, string TableName, bool bLimitChildRows,
											bool DontUseCache, bool ForeignKeyCheck);
			void RemoveLastChange(Page page);
			int GetDeleteCountFromSession( Page page, string TableName, int iToRow );
			int GetInsertCountFromSession( Page page, string TableName, int iToRow );
			void DoOnApplyChanges(Page page);
			void DoOnRefresh(Page page);
			void DoOnScroll(string TableName, int currentRow, int priorRow);
			int IndexOfEcoDataMember(Page page, string DataMember);
			bool HasAutoApplyEvent();
			EcoSpace GetEcoSpace(Page page);
			PropertyDescriptorCollection GetPropertyDescriptors(Object o);
			void UpdateDatabase(Page page);
			Object GetColumnValue(Page page, string TableName, string ColumnName, int iRow, out Type DataType);
			Object GetColumnValue(Page page, ElementHandle h, string ColumnName, int iRow, out Type DataType);
			Object GetEcoObject(ElementHandle handle, int index);
			int GetPhysicalRowCount(Page page, ElementHandle handle);
			bool IsDetailObject(ElementHandle handle, bool Reset);
			int CheckParentRow(EcoPageStateManager manager, ElementHandle handle, String DataMember, int iParentRow);
			void SetEcoSpaceActive(Page page, bool value);
			void SetColumnValue(Page page, ElementHandle handle, int iRow, PropertyDescriptor pd, string value);
			void StartUndoBlock(ElementHandle handle);
			void UndoAllChanges(Page page, ElementHandle handle);
			void UndoLatestChange(Page page, ElementHandle handle);
		}

	[ToolboxItemFilter("System.Web.UI")]
	[ToolboxBitmap(typeof(Borland.Data.Web.Eco.EcoDataSource),
			"Borland.Data.Web.Eco.EcoDataSource.bmp")]
	[Designer("Borland.Data.Web.DBWebDataSourceDesigner")]
	public class EcoDataSource: MarshalByValueComponent, Borland.Data.Web.IDBDataSource, IDBDataSourceDesign, ISerializable, ISupportInitialize, System.ComponentModel.IListSource, IPageStateManager, IEcoPageStateManager
	{
		private bool FEcoSpaceActive;
		private bool FAutoUpdate;
		// by default, ":_ctrl"
		private string FAspGridId;
		private string FName;
		private string FDataSourceName;

		private ErrorHtmlOption FErrorOption;
	  private NameValueCollection FNavigationControls;
     private ArrayList FGoToListboxes;
     private ArrayList FLocateControlList;
	  protected DBWebControlCollection controls;
	  protected EcoPageStateManagerCollection pageStateManagerCollection;
     private EcoHandleCollection FEcoHandles;

	  protected Color FErrorDlgBorderColor;
	  protected Color FErrorDlgForeColor;
	  protected Color FErrorDlgBackColor;
	  protected Unit FErrorDlgBorderWidth;
	  protected WebControl FRowStateManager;



	public EcoDataSource(): base()
	{
		FName = null;
		FRowStateManager = null;
		FEcoHandles = new EcoHandleCollection();
		pageStateManagerCollection = new EcoPageStateManagerCollection();
		OnApplyChangesRequest = null;
		OnError = null;
		FErrorDlgBorderColor = System.Drawing.Color.Red;
		FErrorDlgBackColor = System.Drawing.Color.Azure;
		FErrorDlgForeColor = System.Drawing.Color.Black;
		FErrorDlgBorderWidth = new Unit(8);
		FAspGridId = DBWebConst.sGridColumnID;
		FErrorOption = ErrorHtmlOption.logOnErrorPage;
		FNavigationControls = new NameValueCollection();
		FGoToListboxes = new ArrayList();
		FLocateControlList = new ArrayList();
		FAutoUpdate = true;
		controls = new DBWebControlCollection();
		OnGetPostCollection = null;
	}

	protected override void Dispose(bool disposing)
	{
		if( disposing )
			if( FEcoSpaceActive && FAutoUpdate)
				SetEcoSpaceActive(null, false);
		base.Dispose(disposing);
	}

		#region ErrorDialog

		[LocalizableCategoryAttribute("ErrorDlg")]
      public System.Drawing.Color ErrorDlgBorderColor
      {
      	get
         {
         	return FErrorDlgBorderColor;
         }
      	set
         {
         	FErrorDlgBorderColor = value;
         }
      }

		[LocalizableCategoryAttribute("ErrorDlg"),
      DefaultValue(ErrorHtmlOption.logOnErrorPage)]
      public ErrorHtmlOption ErrorOption
      {
      	get
         {
         	return FErrorOption;
         }
      	set
         {
         	FErrorOption = value;
         }
      }

		[LocalizableCategoryAttribute("ErrorDlg")]
      public Unit ErrorDlgBorderWidth
      {
      	get
         {
         	return FErrorDlgBorderWidth;
         }
      	set
         {
         	FErrorDlgBorderWidth = value;
         }
      }

		[LocalizableCategoryAttribute("ErrorDlg")]
      public System.Drawing.Color ErrorDlgBackColor
      {
      	get
         {
         	return FErrorDlgBackColor;
         }
      	set
         {
         	FErrorDlgBackColor = value;
         }
      }

		[LocalizableCategoryAttribute("ErrorDlg")]
      public System.Drawing.Color ErrorDlgForeColor
      {
      	get
         {
         	return FErrorDlgForeColor;
         }
      	set
         {
         	FErrorDlgForeColor = value;
         }
      }

		#endregion ErrorDialog

		#region ISupportsInitialize and IInitializable

      void ISupportInitialize.BeginInit()
      {  // Previously initializing DataSet, which is wrong;
         // the Form already takes care of this.
      }

      void ISupportInitialize.EndInit()
      {
      }

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
		}

		IList IListSource.GetList()
		{
			return null;
		}

		bool IListSource.ContainsListCollection
		{
			get
			{
				return false;
			}
		}
		#endregion ISupportsInitialize and IInitializable

		#region IDBDataSourceDesign

		eRemoveBindingType IDBDataSourceDesign.UpdateControlForRemoved(IDBWebDataLink webControl, ComponentEventArgs ce)
		{
			eRemoveBindingType eVal = eRemoveBindingType.erbtNone;
			if( webControl != null )
			{
				EcoDataSource ds = this as EcoDataSource;
				if( ce.Component == ds )
					eVal = eRemoveBindingType.erbtAll;
				else if(ce.Component is ElementHandle)
				{
					string ElementName = Convert.ToString(DU.GetPropertyValue(webControl, "TableName" ));
					int index = EcoHandles.IndexOf(ElementName);
					if( index >= 0 )
					{
						if( EcoHandles.IndexOf(ce.Component) == index )
						{
							DU.SetPropertyValue(webControl, "TableName", null );
							eVal = eRemoveBindingType.erbtTablesAndColumns;
						}
						else
						{
							ElementHandle handle = EcoWebUtils.GetRootHandle(ce.Component as ElementHandle);
							while( handle != null )
							{
								if( handle == ce.Component )
								{
									eVal = eRemoveBindingType.erbtTablesAndColumns;
									break;
								}
								handle = EcoWebUtils.GetRootHandle(handle);
							}
						}
					}
				}
			}
			return eVal;
		}
		bool IDBDataSourceDesign.UpdateParentControl(IDBWebDataLink webControl, ComponentChangedEventArgs ce)
		{
			EcoDataSource ds = this as EcoDataSource;
			if( ce.Component == null || ce.Member == null || ClassUtils.IsEmpty(ce.Member.Name) )
				return false;
			string propertyName = ce.Member.Name;
			if( ds == ce.Component || this.DataSource == ce.Component )
			{
				if( propertyName == "Name" )
				{
					object TableName = DU.GetPropertyValue(webControl, DBTypes.sTableName );
					DU.SetPropertyValue(webControl, DBTypes.sDBDataSource, ce.Component );
					if( TableName != null )
					{
						DU.SetPropertyValue(webControl, DBTypes.sTableName, TableName);
					}
				}
				return true;
			}
			else if (ce.Component is ElementHandle )
			{
				int index = EcoHandles.IndexOf(ce.Component);
				if( propertyName == "Name" && index >= 0)
				{
					string Name = (ce.Component as Component).Site.Name;
					if( Name != null )
						EcoHandles.SetName(index, Name);
				}
				return index >= 0;
			}
			return false;
		}
		DataSet IDBDataSourceDesign.DataSetFromDataSource(Object o)
      {
         return null;
      }

      Object IDBDataSourceDesign.GetDBObject(string DataMember)
      {
         return (this as IDBDataSource).GetTableOrView(null, DataMember);
      }

		protected void SetEcoSpaceActive(Page page, bool value)
		{
			EcoSpace ecoSpace = GetEcoSpace(page);
			if( ecoSpace != null && ecoSpace.Active != value )
			{
				ecoSpace.Active = value;
			}
			FEcoSpaceActive = value;
		}

		protected Object GetEcoObject(ElementHandle handle, int index)
		{
			if( handle != null)
			{
				if( handle.Element != null && handle.Element.AsObject is System.Array )
				{
					System.Array ObjArray = handle.Element.AsObject as System.Array;
					if( ObjArray != null && ObjArray.Length > index )
						return ObjArray.GetValue(index);
				}
				else
				{
					if( (handle as IList).Count >= 0 && (handle as IList).Count > index)
						return handle.Element.GetAsCollection()[index];
				}
			}
			return null;
		}

	  bool IDBDataSourceDesign.InitDataMemberList(ITypeDescriptorContext context, System.Windows.Forms.ListBox lb, string oldValue, ref int oldColumnIndex)
		{
			bool bFound = false;
			lb.Items.Clear();
			oldColumnIndex = -1;
			for( int i = 0; i < FEcoHandles.Count; i++ )
			{
				string sItem = (FEcoHandles[i] as IComponent).Site.Name;
				lb.Items.Add(sItem);
            if( oldValue != null && sItem == oldValue )
            {
               lb.SelectedIndex = lb.Items.Count -1;
               oldColumnIndex = lb.SelectedIndex;
               bFound = true;
            }
            if( !bFound )
               lb.SelectedIndex = 0;
         }
         return lb.Items.Count > 0;
      }

      bool IDBDataSourceDesign.InitColumnList(System.Windows.Forms.ListBox lb, Object ADBObject,
                                       ArrayList ExcludedTypes, ArrayList ValidTypes, string oldValue, out int oldColumnIndex,
                                       bool IsAggregateControl, AggType AggregateType)
      {
			bool bFound = false;
			lb.Items.Clear();
			oldColumnIndex = -1;
			ElementHandle handle = ADBObject as ElementHandle;
			if( !FEcoSpaceActive )
				SetEcoSpaceActive(null, true);
			PropertyDescriptorCollection pdc = (this as IEcoPageStateManager).GetPropertyDescriptors(handle);
			if( pdc != null )
			{
				for( int i = 0; i < pdc.Count; i++ )
				{
					lb.Items.Add(pdc[i].Name);
					if( pdc[i].Name == oldValue )
					{
						lb.SelectedIndex = lb.Items.Count -1;
						bFound = true;
					}
				}
			}
			if( !bFound && lb.Items.Count > 0 )
				lb.SelectedIndex = 0;
			return lb.Items.Count > 0;
		}
      
		bool IDBDataSourceDesign.CheckColumnName(Page page, Object ADBObject, string ColumnName)
      { // TODO: find and check member names
         return true;
      }

		Object IDBDataSourceDesign.CheckExpression(Page page, string Expression)
		{
			int index = IndexOfEcoDataMember(page, Expression);
         if( index >= 0 )
            return FEcoHandles[index];
         return null;
      }
      #endregion


		#region IDBDataSource

		private ListBox GetGoToListBox(string ID)
      {
         for( int i = 0; i < FGoToListboxes.Count; i++ )
            if( (FGoToListboxes[i] as ListBox).ID == ID )
               return (FGoToListboxes[i] as ListBox);
         return null;
      }

      private bool SetGoToControl(NameValueCollection postCollection, string Key, string Value)
      {
         int index = Key.IndexOf(DBWebConst.Splitter);
         string Key1 = Key.Substring(0, index);
         string Key2 = Key.Substring(index + 1);
         if( postCollection[Key2] != null )
         {
            if( Key1 == Key2 )
            {
               ListBox lb = GetGoToListBox(Key1);
               if( lb != null )
               {  // if GOTO control is a listbox, set to selected Index
                  for( int i = 0; i < lb.Items.Count; i++ )
                  {
                     if( lb.Items[i].ToString() == postCollection[Key1] )
                     {
                        postCollection.Add(Value, Convert.ToString(i));
                        return true;
                     }
                  }
               }
            }
            if( ClassUtils.IsNumber(postCollection[Key1]) )
            {  // if GOTO control is TextBox, set to its numeric value
               postCollection.Add(Value, postCollection[Key1]);
               return true;
            }
         }
         return false;
      }

      private bool SetLocateControls(Page page, NameValueCollection postCollection)
      {
         LocateObject locateObj;
         for( int i = 0; i < FLocateControlList.Count; i++ )
         {
            locateObj = FLocateControlList[i] as LocateObject;
            if( postCollection[locateObj.SubmitControl.ID] != null )
            {
               ArrayList KeyValues = new ArrayList();
               for( int j = 0; j < locateObj.ValueControls.Count; j++ )
                  KeyValues.Add(postCollection[(locateObj.ValueControls[j] as WebControl).ID]);
               int iRow = Locate(page, locateObj.TableName, locateObj.KeyFields,
                                 KeyValues, locateObj.CaseInsensitive,
                                 locateObj.PartialKey);
               if( iRow >= 0 )
                  postCollection.Add(locateObj.TableName + DBWebConst.Splitter + DBWebConst.sSetRow, Convert.ToString(iRow));
               return true;
            }
         }
         return false;
      }

		int IDBDataSource.GetParentRow(Page page, string TableName)
		{
			ElementHandle handle = ParentHandleForChild(TableName);
			if( handle == null )
				return -1;
			else
			{
				return GetPageStateManager(page).getCurrentRow(FEcoHandles.GetName(handle));
			}
		}

		int IDBDataSource.GetFirstParentRow(Page page, string TableName)
		{
			ElementHandle handle = FEcoHandles.GetHandleByName(TableName);
			ElementHandle nextHandle = ParentHandleForChild(handle);
			while( nextHandle != null )
			{
				handle = nextHandle;
				nextHandle = ParentHandleForChild(handle);
			}
			return GetPageStateManager(page).getCurrentRow(FEcoHandles.GetName(handle));
		}

		bool IDBDataSource.HasApplyEvent()
      {
			return OnApplyChangesRequest != null;
      }

		bool IDBDataSource.ChangesCached
		{
			get
			{
				return !FAutoUpdate;
			}
		}
		
		void IDBDataSource.SetNavigationControls(Page page, NameValueCollection postCollection)
      {
         if( SetLocateControls(page, postCollection) )
            return;
         string Key;
         string Value;
         for( int i = 0; i < FNavigationControls.Count; i++ )
         {
            Key = FNavigationControls.GetKey(i);
            if( postCollection[Key] != null )
            {
               Value = FNavigationControls[i];
               postCollection.Add(Value, "true");
               return;
            }
            else if( Key.IndexOf(DBWebConst.Splitter) > 0 )
            {
               if( SetGoToControl( postCollection, Key, FNavigationControls[i] ) )
                  return;
            }
         }
      }

		bool IDBDataSource.HasDelta(Page page, string TableName)
		{
			if( ClassUtils.IsDesignTime(page) || FAutoUpdate )
				return false;

			ElementHandle handle = GetHandleForDataMember(page, TableName, true, false, true) as ElementHandle;
			if( handle == null )
				return false;
			IEcoServiceProvider serviceProvider = handle;
			IUndoService undoService = serviceProvider.GetEcoService(typeof(IUndoService)) as IUndoService;
			return undoService.UndoList.Count > 0;
		}

      Object IDBDataSource.GetAggregateValue(Page page, string TableName, string ColumnName, AggType aggType, bool ignoreNullValues)
      {
          return GetPageStateManager(page).GetAggregateValue(TableName, ColumnName, aggType, ignoreNullValues);
      }

		Object IDBDataSource.GetColumnValue(Page page, string TableName, string ColumnName)
		{
			Type DataType;
			return (this as IDBDataSource).GetColumnValue(page, TableName, ColumnName, out DataType);
		}
		Object IDBDataSource.GetColumnValue(Page page, string TableName, string ColumnName, out Type DataType)
		{
			DataType = null;
			int RowCount =  GetPageStateManager(page).GetRowCount(TableName);
			if (RowCount <= 0)
				return null;
			int iRow = GetPageStateManager(page).getCurrentRow(TableName);
			return (this as IEcoPageStateManager).GetColumnValue(page, TableName, ColumnName, iRow, out DataType);
		}

      int IDBDataSource.GetRowCount(Page page, string TableName)
      {
			return GetPageStateManager(page).GetRowCount(TableName);
		}

      int IDBDataSource.GetDisplayRowCount(Page page, string TableName)
      {
			return GetPageStateManager(page).GetRowCount(TableName);
      }
   	int IDBDataSource.GetCurrentRow(Page page, string TableName)
      {
      	return GetPageStateManager(page).getCurrentRow(TableName);
      }
   	int IDBDataSource.GetDisplayRow(Page page, string TableName)
      {
      	return GetPageStateManager(page).getCurrentRow(TableName);
      }
   	int IDBDataSource.GetLastRow(Page page, string TableName)
      {
      	return GetPageStateManager(page).getLastRow(TableName);
      }
      bool IDBDataSource.IsDataBound(string TableName)
		{
         return FEcoHandles.Count > 0;
		}

		Object IDBDataSource.GetTableOrView(Page page, string TableName)
		{
			return GetHandleForDataMember(page, TableName, true, false, true);
		}

		void IDBDataSource.AddControl(WebControl control)
		{
			if(controls.IndexOf(control) < 0)
			{
				controls.Add(control);
				if( control is DBWebGrid )
				{
					DBWebGrid grid = control as DBWebGrid;
					if( !ClassUtils.IsDesignTime(control.Page) && grid.Columns != null )
						control.Page.Session[control.ID + DBWebConst.sGridColumnCount] = grid.Columns.Count;
				}
			}
		}
		void IDBDataSource.RemoveControl(WebControl control)
		{
			if(controls.IndexOf(control) >= 0)
			{
				controls.Remove(control);
			}
		}

		string IDBDataSource.GetDataSourceName(Page page)
		{
			if( FDataSourceName == null )
				SetDataSourceName(page);
			return FDataSourceName;
		}
		
		Object IDBDataSource.GetDataSource(Page page)
      {
         return FEcoHandles;
      }

		ErrorHtmlOption IDBDataSource.ErrorOption
		{
			get
			{
				return FErrorOption;
			}
		}

		string IDBDataSource.GetErrorHtml(Page page, string TableName)
      {
         if( ClassUtils.IsDesignTime(page) || TableName == null || TableName == "" )
         	return null;
         else
      		return GetPageStateManager(page).ErrorHtml(TableName);
      }

      string IDBDataSource.GetWarningHtml(Page page, string TableName)
      {
         if( ClassUtils.IsDesignTime(page) || TableName == null || TableName == "" )
         	return null;
         else
      		return GetPageStateManager(page).WarningsHtml(TableName);
      }
      void IDBDataSource.RegisterLocateControl(string KeyFields, ArrayList KeyValueControls, WebControl SubmitControl, string TableName)
      {
         (this as IDBDataSource).RegisterLocateControl(KeyFields, KeyValueControls, SubmitControl, TableName, false, false);
      }
      void IDBDataSource.RegisterLocateControl(string KeyFields, ArrayList KeyValueControls, WebControl SubmitControl, string TableName, bool CaseInsensitive)
      {
         (this as IDBDataSource).RegisterLocateControl(KeyFields, KeyValueControls, SubmitControl, TableName, CaseInsensitive, false);
      }
      void IDBDataSource.RegisterLocateControl(string KeyFields, ArrayList KeyValueControls, WebControl SubmitControl, string TableName, bool CaseInsensitive, bool PartialKey)
      {
         FLocateControlList.Add(new LocateObject(KeyFields, KeyValueControls, SubmitControl, TableName, CaseInsensitive, PartialKey ) );
      }
      void IDBDataSource.RegisterApplyControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sApplyText);
      }
      void IDBDataSource.RegisterRefreshControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sRefreshText);
      }
      void IDBDataSource.RegisterNextControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sNextText);
      }
      void IDBDataSource.RegisterPreviousControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sPrevText);
      }
      void IDBDataSource.RegisterFirstControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sFirstText);
      }
      void IDBDataSource.RegisterLastControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sLastText);
      }
      void IDBDataSource.RegisterInsertControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sInsertText);
      }
      void IDBDataSource.RegisterDeleteControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sDeleteText);
      }
      void IDBDataSource.RegisterUpdateControl(WebControl control, string tableName)
      {
      }
      void IDBDataSource.RegisterCancelControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sCancelChange);
      }
      void IDBDataSource.RegisterUndoControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sUndoText);
      }
      void IDBDataSource.RegisterUndoAllControl(WebControl control, string tableName)
      {
         FNavigationControls.Add(control.ID, tableName + DBWebConst.Splitter + DBWebConst.sUndoAllText);
      }
      void IDBDataSource.RegisterGoToControl(WebControl ValueControl, WebControl SubmitControl, string tableName)
      {
         FNavigationControls.Add(ValueControl.ID + DBWebConst.Splitter + SubmitControl.ID, tableName + DBWebConst.Splitter + DBWebConst.sSetRow);
         if( (ValueControl.ID == SubmitControl.ID) && (ValueControl is ListBox ) )
            FGoToListboxes.Add(ValueControl);
      }

		void IDBDataSource.DeleteUserXmlFile(Page page)
		{
		}

		bool IDBDataSource.HasDetailRecords(Page page, string TableName)
      {
         return false;
		}
		#endregion IDBDataSource

      #region Page State Manager access

      protected EcoPageStateManager GetPageStateManager(Page page)
      {
      	EcoPageStateManager psm = pageStateManagerCollection.FindPageStateManager(page);
         if( psm == null )
         {
         	psm = new EcoPageStateManager(page, this, FAspGridId);
            pageStateManagerCollection.Add(psm);
            if( ClassUtils.IsDesignTime(page) )
               EcoHandles.PageStateManager = psm;
         }
      	return psm;
      }
	   #endregion Page State Manager access

		protected ElementHandle ParentHandleForChild(string childHandle)
		{
			ElementHandle handle = FEcoHandles.GetHandleByName(childHandle);
			return ParentHandleForChild(handle);
		}
		protected ElementHandle ParentHandleForChild(ElementHandle handle)
		{
			if( handle != null )
			{
				CursorHandle cursorHandle = EcoWebUtils.GetRootHandle(handle) as CursorHandle;
				if( cursorHandle != null )
					return cursorHandle.RootHandle;
			}
			return null;
		}

		#region IEcoPageStateManager

		void IEcoPageStateManager.StartUndoBlock(ElementHandle handle)
		{
			if( !FAutoUpdate )
			{
				IEcoServiceProvider serviceProvider = handle;
				IUndoService undoService = serviceProvider.GetEcoService(typeof(IUndoService)) as IUndoService;
				undoService.StartUndoBlock();
			}
		}
		void IEcoPageStateManager.UndoLatestChange(Page page, ElementHandle handle)
		{
			if( !FAutoUpdate )
			{
				IEcoServiceProvider serviceProvider = handle;
				IUndoService undoService = serviceProvider.GetEcoService( typeof(IUndoService)) as IUndoService;
				undoService.UndoLatest();
			}
		}
		void IEcoPageStateManager.UndoAllChanges(Page page, ElementHandle handle)
		{
			if( !FAutoUpdate )
			{
				IEcoServiceProvider serviceProvider = handle;
				IUndoService undoService = serviceProvider.GetEcoService(typeof(IUndoService)) as IUndoService;
				while( undoService.UndoList.Count > 0 )
					undoService.UndoLatest();
				undoService.StartUndoBlock();
			}
		}

		void IEcoPageStateManager.SetColumnValue(Page page, ElementHandle handle, int iRow, PropertyDescriptor pd, string value)
		{
			SetColumnValue(page, handle, iRow, pd, value);
		}
		void IEcoPageStateManager.SetEcoSpaceActive(Page page, bool value)
		{
			if( !FEcoSpaceActive )
				SetEcoSpaceActive(page, value);
		}
		int IEcoPageStateManager.CheckParentRow(EcoPageStateManager manager, ElementHandle handle, String DataMember, int iParentRow)
		{
			int iRow = -1;
			CursorHandle cursorHandle = EcoWebUtils.GetRootHandle(handle) as CursorHandle;
			if( cursorHandle != null )
			{
				iRow = cursorHandle.Position;
				cursorHandle.Position = iParentRow;
				manager.SetRowCount(DataMember, (this as IEcoPageStateManager).GetPhysicalRowCount(manager.GetPage(), handle));
				if( manager.GetRowCount(DataMember) >= 0 )
					manager.setCurrentRow(DataMember, 0);
				else
					manager.setCurrentRow(DataMember, -1);
			}
			return iRow;
		}

		bool IEcoPageStateManager.IsDetailObject(ElementHandle handle, bool Reset)
		{
			CursorHandle cursorHandle = EcoWebUtils.GetRootHandle(handle) as CursorHandle;
			if( cursorHandle != null )
			{
				if( Reset && cursorHandle.Position < 0 )
					cursorHandle.Position = 0;
				ElementHandle ElHandle = EcoWebUtils.GetRootHandle(cursorHandle);
				if( EcoHandleCollection.IsValidHandleType(ElHandle) )
					return true;
			}
			return false;
		}

		int IEcoPageStateManager.GetPhysicalRowCount(Page page, ElementHandle handle)
		{
			if( handle != null)
			{
				if( handle.Element != null )
				{
					System.Object o = handle.Element.AsObject;
					if( o is System.Array )
						return (o as System.Array).Length;
					else if( o is IList )
						return (o as IList).Count;
				}
				else 
					return (handle as IList).Count;
         }
         return 0;
      }

		Object IEcoPageStateManager.GetEcoObject(ElementHandle handle, int index)
      {
         return GetEcoObject(handle, index);
      }

      void IEcoPageStateManager.UpdateDatabase(Page page)
      {
         UpdateDatabase(page);
      }

		Object IEcoPageStateManager.GetColumnValue(Page page, string TableName, string ColumnName, int iRow, out Type DataType)
		{
			Object value = null;
			ElementHandle h = (this as IDBDataSource).GetTableOrView(page, TableName) as ElementHandle;
			value = (this as IEcoPageStateManager).GetColumnValue(page, h, ColumnName, iRow, out DataType);
			return value;
		}

		Object IEcoPageStateManager.GetColumnValue(Page page, ElementHandle handle, string ColumnName, int iRow, out Type DataType)
		{
			DataType = null;
			if (handle == null)
				return  null;
			IList list = handle;
			PropertyDescriptorCollection pdc = (this as IEcoPageStateManager).GetPropertyDescriptors(handle);
			if ((pdc == null) ||(iRow < 0) || (iRow >= list.Count))
				return null;
			PropertyDescriptor pd = pdc[ColumnName];
			DataType = pd.PropertyType;
			IObject thisIObject = handle.Element.GetAsCollection()[iRow] as IObject;
			return pd.GetValue(handle.RenderElement(thisIObject));
		}

		PropertyDescriptorCollection IEcoPageStateManager.GetPropertyDescriptors(Object o)
		{
			ITypedList typedList = o as ITypedList;
			if( typedList != null )
				return typedList.GetItemProperties(null);
			return null;
		}

      EcoSpace IEcoPageStateManager.GetEcoSpace(Page page)
      {
         return GetEcoSpace(page);
      }

		Object IEcoPageStateManager.GetTableOrView(Page page, string TableName, bool bLimitChildRows,
											bool DontUseCache, bool ForeignKeyCheck)
		{
			return GetHandleForDataMember(page, TableName, bLimitChildRows, DontUseCache, ForeignKeyCheck);
		}

      void IEcoPageStateManager.RemoveLastChange(Page page)
      {
      }

	   int IEcoPageStateManager.GetDeleteCountFromSession( Page page, string TableName, int iToRow )
	   {
		   return GetDeleteOrInsertCountFromSession(page, TableName, iToRow, DBWebConst.sDbxDelete);
	   }

	   int IEcoPageStateManager.GetInsertCountFromSession( Page page, string TableName, int iToRow )
	   {
		   return GetDeleteOrInsertCountFromSession(page, TableName, iToRow, DBWebConst.sDbxInsert);
	   }

		protected void SetDataSourceName(Page page)
		{
			if( ClassUtils.IsDesignTime(page ) )
				FDataSourceName = this.Site.Name;
			else
			{
				Type t = page.GetType();
				FieldInfo[] fields = t.GetFields(BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic);
				if( fields != null )
				{
					foreach( FieldInfo field in fields )
					{
						Object o = field.GetValue(page);
						if( o != null && o == this )
						{
							FDataSourceName = field.Name;
							break;
						}
					}
				}
			}
		}

		void IEcoPageStateManager.DoOnApplyChanges(Page page)
      {
      	DoOnApplyChanges(page, OnApplyChangesRequest);
      }
		void IEcoPageStateManager.DoOnRefresh(Page page)
      {
      	DoOnRefresh(page);
      }
      #region IPageStateManager
      void IPageStateManager.DoOnError(Page page)
      {
      	DoOnError(page);
      }
		void IEcoPageStateManager.DoOnScroll(string TableName, int currentRow, int priorRow)
      {
      	DoOnScroll(TableName, currentRow, priorRow);
      }
      ArrayList IPageStateManager.GetErrors(Page page)
      {
         return GetPageStateManager(page).Errors;
      }
      ArrayList IPageStateManager.GetWarnings(Page page)
	   {
         return GetPageStateManager(page).Warnings;
	   }
      #endregion

		bool IPageStateManager.SetChangedValues(Page page, NameValueCollection postCollection,
											WebControl control)
		{
			EcoPageStateManager manager = GetPageStateManager(page);
			// if changed values have already been set , don't set them
			// again.
			bool bRetval = !manager.GetPageFieldsWritten();
			if( postCollection.Count > 0 && bRetval )
				if( !manager.GetPostCollectionValuesSet() )
				{
					CheckCurrentRows(page);
					if( !DoOnGetPostCollection(postCollection) )
					{
						SetHandleNames(page);
						CheckCurrentRows(page);
						manager.SetChangedValues(postCollection);
					}
				}
			return bRetval;
		}
		int IEcoPageStateManager.IndexOfEcoDataMember(Page page, string DataMember)
		{
			return IndexOfEcoDataMember(page, DataMember);
		}
		bool IEcoPageStateManager.HasAutoApplyEvent()
		{
			return false;
      }

		#endregion

      #region table access methods

		[Editor(typeof(Borland.Data.Web.DataSourceEditor), typeof(UITypeEditor)),
		LocalizableCategoryAttribute("DBDataSource"),
		DefaultValue(null)]
		public Object DataSource
		{
			get
			{
				return FEcoHandles;
			}
		}


		// Extract Updated Value for a particular Row/Col/Tablename
	  protected object GetKeyValueFromSession(Page page, string TableName, int iRow, int iCol)
	  {
		string tableName = "";
		 int row = -1;
		 int col = -1;
		 string oldValue;
		 for( int i = 0;i < page.Session.Count; i++ )
		 {
			if( page.Session.Keys[i].StartsWith( DBWebConst.sDbxDelta + TableName + DBWebConst.Splitter)  &&
					page.Session.Keys[i].IndexOf( DBWebConst.sDbxInsert ) < 0 )
			{
				ArrayList parentRows = ClassUtils.GetRowColFromKey(page.Session.Keys[i], GetPageStateManager(page).GetFullPageName(), out tableName, out row, out col, out oldValue);
				if( tableName == TableName && row == iRow && col == iCol )
				{
               return page.Session[i];
				}
			}
		 }
		 return null;
	  }

		protected int GetDeleteOrInsertCountFromSession( Page page, string TableName, int iToRow, string KeyType )
		{
			int iCount = 0;
			return iCount;
		}

		public int IndexOfEcoDataMember(Page page, string DataMember)
		{
			int Index = FEcoHandles.IndexOf(DataMember);
			if( Index < 0 && DataMember != null )
			{
				return FEcoHandles.SetName(page, DataMember);
			}
			return Index;
      }


		[Editor(typeof(Borland.Data.Web.Eco.EcoHandlesEditor), typeof(UITypeEditor))]
		[LocalizableCategoryAttribute("Data")]
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
		public EcoHandleCollection EcoHandles
		{
			get
			{
				return FEcoHandles;
			}
		}

		// TODO: to which category does this belong?
		[LocalizableCategoryAttribute("Data")]
		[DefaultValue(true)]
		public bool AutoUpdate
		{
			get
			{
				return FAutoUpdate;
			}
			set
			{
				FAutoUpdate = value;
			}
		}

      public EcoSpace GetEcoSpace( Page page, ElementHandle handle )
      {
			ReferenceHandle rh = GetRoot(handle);
         if( rh != null )
         {
            if( rh.EcoSpace == null )
            {
               if( rh.EcoSpaceType != null )
               {
                  rh.EcoSpace = Activator.CreateInstance(rh.EcoSpaceType) as EcoSpace;
               }
               return rh.EcoSpace;
            }
            else
               return rh.EcoSpace;
         }
         return null;
      }

      protected EcoSpace GetEcoSpace(Page page)
      {
         if( FEcoHandles.Count < 0 )
            return null;
         return GetEcoSpace(page, FEcoHandles[0]);
		}

		protected ReferenceHandle GetRoot(ElementHandle h)
		{  // TODO: needs to be handled by EcoHandleCollection
			while( h!= null && !(h is ReferenceHandle) )
			{
				if( h is ExpressionHandle )
					h = (h as ExpressionHandle).RootHandle;
				else if( h is OclPSHandle )
					h = (h as OclPSHandle).RootHandle;
				else
					h = null;
			}
			if( h is ReferenceHandle )
				 return h as ReferenceHandle;
         return null;
		}

		protected void CheckRowState(Page page, ElementHandle h, string DataMember)
		{
			EcoPageStateManager manager = GetPageStateManager(page);
			if( manager.getCurrentRow(DataMember) < 0 )
			{
				IList list = (h as IList);
				int iRowCount = list.Count;
				if( iRowCount > 0 )
				{
					manager.setCurrentRow(DataMember, 0);
					manager.SetRowCount(DataMember, iRowCount);
				}
			}
		}

		protected void SetHandleNames(Page page)
		{  // only called at runtime
			Type t = page.GetType();
			FieldInfo[] fields = t.GetFields( BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Public );
			if( fields != null )
			{
				for( int i = 0; i < fields.Length; i++ )
				{
					FieldInfo info = fields[i];
					if( info != null )
					{
						Object o = info.GetValue(page);
						if( o is ElementHandle )
						{
							int Index = FEcoHandles.IndexOf(o);
							if( Index >= 0 )
								FEcoHandles.SetName(Index, info.Name);
						}
						else if( o == this )
						{
							FName = info.Name;
						}
					}
				}
			}
		}
		// The CurrentRow has been stored off with the session object.
		// If the iCurrentRow does not point to this object, then
		// someone had deleted or inserted a row, so we need to finc the
		// real CurrentRow
		protected void CheckCurrentRows(Page page)
		{
			try
			{
				for( int i = 0; i < FEcoHandles.Count; i++ )
				{
					if( !(this as IEcoPageStateManager).IsDetailObject(FEcoHandles[i], false) )
					{
						String DataMember = EcoHandles.GetName(FEcoHandles[i]);
						int iRow = GetPageStateManager(page).getCurrentRow(DataMember);
						ArrayList expectedObject = GetPageStateManager(page).GetCurrentObject(DataMember) as ArrayList;
						if( iRow >= 0 )
							if( !CheckCurrentRow(page, expectedObject, FEcoHandles[i], DataMember, iRow ) )
								FindCurrentObject(page, expectedObject, FEcoHandles[i], DataMember);
					}
				}
			}
			catch
			{
				// ignore errors here
			}
		}

		protected void FindCurrentObject(Page page, ArrayList expectedObject, ElementHandle handle, string DataMember)
		{
			bool bFound = false;
			// comparisons will otherwise fail
			EcoPageStateManager manager = GetPageStateManager(page);
			manager.setLastRow(DataMember, -1);
			IList list = (handle as IList);
			for( int i = 0; i < list.Count; i++ )
			{
				if( CheckCurrentRow(page, expectedObject, handle, DataMember, i ) )
				{
					manager.setCurrentRow(DataMember, i);
					bFound = true;
					break;
				}
			}
			if( !bFound )
			{
				if( list.Count > 0 )
					manager.setCurrentRow(DataMember, 0 );
				else
					manager.setCurrentRow(DataMember, -1 );
			}
		}

		protected bool CheckCurrentRow(Page page, ArrayList lastRow, ElementHandle handle, string DataMember, int iRow)
		{
			if( lastRow == null )
				return true;
			PropertyDescriptorCollection pdc = (this as IEcoPageStateManager).GetPropertyDescriptors(handle);
			for(int i = 0; i < pdc.Count; i++ )
			{
				PropertyDescriptor pd = pdc[i];
				if( pd.PropertyType != Type.GetType(TypeLiterals.SystemByteArray) &&
					 pd.PropertyType != Type.GetType(TypeLiterals.SystemCharArray) )
				{
					Type DataType;
					if( !ClassUtils.CompareObjects((this as IEcoPageStateManager).GetColumnValue(page, handle, pd.Name, iRow, out DataType), lastRow[i], pd.PropertyType.ToString()) )
						return false;
				}
			}
			return true;
		}

		protected Object GetHandleForDataMember(Page page, string DataMember,
								bool bLimitChildRows, bool bDontUseCache,
								bool bSetForeignKeys)
		{
			int index = IndexOfEcoDataMember(page, DataMember);
			if( index >= 0 )
			{
				if( !FEcoSpaceActive )
					SetEcoSpaceActive(page, true);
				if( EcoWebUtils.GetRootHandle(FEcoHandles[index]) == null )
					return null;
            // TODO: should this be necessary????
//				CheckRowState(page, FEcoHandles[index], DataMember);
				return FEcoHandles[index];
			}
			return null;
		}

		public void SetKeyFieldsReadOnly(string TableName, Object ATableOrView,
						bool SetChild, bool bReadOnlyValue)
      {
      }

      private bool KeyMatch( DataRow row, ArrayList keyValues, DataColumn [] columns )
      {
      	for( int i = 0; i < columns.Length; i++ )
         {
         	string s1 = row[columns[i].ColumnName].ToString();
            string s2 = keyValues[i].ToString();
         	if( s1 != s2 )
            	return false;
         }
         return true;
	  }
      private bool SameRow( DataRow targetRow, DataRow sourceRow, DataColumn [] columns )
      {
         for( int i = 0; i < columns.Length; i++ )
         {
         	string columnName = columns[i].ColumnName;
            if( sourceRow[columnName].ToString() != targetRow[columnName].ToString() )
            	return false;
			}
			return columns.Length > 0;
		}

	  /* function is only called when child table exists.  It returns a
		 DataView of the child table containing only those rows which are
		 controlled by the parent key*/

	  #region Locate

      protected int Locate(Page page, string TableName, string KeyFields, ArrayList KeyValues, bool CaseInsensitive, bool PartialKey)
      {
        Object o = GetHandleForDataMember(page, TableName, true, false, false);
        return -1;
      }
	  #endregion Locate

	  #endregion table access methods

		#region UpdateHandles

		protected IPersistenceService GetPersistenceService(EcoSpace ecoSpace)
		{
			return ecoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
		}
		protected IDirtyListService GetDirtyListService(EcoSpace ecoSpace)
		{
			return ecoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
		}

		protected void UpdateDatabase(Page page)
		{
			EcoSpace ecoSpace = GetEcoSpace(page);
			IPersistenceService persistence = GetPersistenceService(ecoSpace);
			IDirtyListService dirtyList = GetDirtyListService(ecoSpace);
			if(  persistence != null && dirtyList != null )
				persistence.UpdateDatabaseWithList(dirtyList.AllDirtyObjects());
		}

		protected void SetColumnValue(Page page, ElementHandle handle, int iRow, int iCol, string value)
		{
			PropertyDescriptorCollection pdc = (this as IEcoPageStateManager).GetPropertyDescriptors(handle);
			if ((pdc == null) ||(iRow < 0 ) )
				return;  // TODO: raise appropriate exception
			PropertyDescriptor pd = pdc[iCol];
			SetColumnValue(page, handle, iRow, pd, value);
		}

		protected void SetColumnValue(Page page, ElementHandle handle, int iRow, PropertyDescriptor pd, string value)
		{
			IList list = handle;
			if (list == null || iRow < 0 || iRow >= list.Count )
				return;  // TODO: raise appropriate exception
			Object newValue = ClassUtils.ObjectFromString(pd.PropertyType, value);
			IObject thisIObject = handle.Element.GetAsCollection()[iRow] as IObject;
			pd.SetValue(handle.RenderElement(thisIObject), newValue);
			handle.EnsureBindingList();
			if( FAutoUpdate )
				UpdateDatabase(page);
			else
				(this as IEcoPageStateManager).StartUndoBlock(handle);
		}

		protected Type GetObjectType(ElementHandle h)
		{
			Type type = null;
			IStaticContext context = h as IStaticContext;
			if( context != null && context.StaticUmlType != null)
			{
				type = context.StaticUmlType.ObjectType;
				if( type.IsArray )
					type = type.GetElementType();
			}
			return type;
		}

		protected void InsertRow(Page page, ElementHandle handle)
		{
			IElementCollection ec = handle.Element as IElementCollection;
			if ((ec != null) && (ec.SupportsAddNew))
				ec.AddNew();
			handle.EnsureBindingList();
			if( FAutoUpdate )
				UpdateDatabase(page);
			else
				(this as IEcoPageStateManager).StartUndoBlock(handle);
	  }

		public void InsertRow(Page page, string DataMember)
		{
			ElementHandle h = (this as IDBDataSource).GetTableOrView(page, DataMember) as ElementHandle;
			InsertRow(page, h);
		}
		public void DeleteRow(Page page, string DataMember, int iRow)
		{
			ElementHandle handle = (this as IDBDataSource).GetTableOrView(page, DataMember) as ElementHandle;
			DeleteRow(page, handle, iRow);
		}
		protected void DeleteRow(Page page, ElementHandle handle, int iRow)
		{
			(handle as IBindingList).RemoveAt(iRow);
			handle.EnsureBindingList();
			if( FAutoUpdate )
				UpdateDatabase(page);
			else
				(this as IEcoPageStateManager).StartUndoBlock(handle);
		}

		#endregion

		#region DBWebControlCollection events

		public event WebControlEvent OnApplyChangesRequest;
		public event WebControlEvent OnRefreshRequest;
		public event PostCollectionEvent OnGetPostCollection;
		public event OnScrollEvent OnScroll;
		public event OnErrorEvent OnError;

		protected virtual void DoOnScroll(string TableName, int currentRow, int priorRow)
		{
			if(OnScroll != null)
			{
				OnScrollEventArgs e = new OnScrollEventArgs(TableName, currentRow, priorRow);
				OnScroll(this, e);
			}
		}

		protected virtual void DoOnError(Page page)
		{
			EcoPageStateManager manager = GetPageStateManager(page);
			if(OnError != null)
			{
//				DataSet ds = DataSetFromDataSource((this as IDBDataSource).GetDataSource(page));
				OnErrorEventArgs e = new OnErrorEventArgs(null, manager.Errors, manager.Warnings);
				OnError(this, e);
			}
			manager.Errors.Clear();
			manager.Warnings.Clear();
		}

		protected virtual bool DoOnGetPostCollection(NameValueCollection postCollection)
		{
			if( OnGetPostCollection != null )
			{
				PostCollectionEventArgs e = new PostCollectionEventArgs(postCollection);
				bool StopChanges;
				OnGetPostCollection(this, e, out StopChanges);
				return StopChanges;
			}
			return false;
		}
		
		protected virtual void DoOnApplyChanges(Page page, WebControlEvent ApplyEvent)
		{
			if( OnApplyChangesRequest != null )
			{
				WebControlEventArgs e = new WebControlEventArgs(null);
				OnApplyChangesRequest(this, e);
				if( FEcoHandles.Count > 0 )
					(this as IEcoPageStateManager).UndoAllChanges(page, FEcoHandles[0]);
			}
		}

		protected virtual void DoOnRefresh(Page page)
		{
			if( OnRefreshRequest != null )
			{
				WebControlEventArgs e = new WebControlEventArgs(null);
				OnRefreshRequest(this, e);
			}
		}

	  #endregion

	}
	#region EcoWebUtils
	public class EcoWebUtils
	{
		public static ElementHandle GetRootHandle(ElementHandle handle)
		{
			return handle is RootedHandle ? ((RootedHandle)handle).RootHandle : null;
		}
	}
	#endregion


}
